<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container px-6 mx-auto">
        <!-- Header -->
        <div class="flex justify-between items-center my-6">
            <div>
                <h2 class="text-2xl font-semibold text-gray-700">
                    <?php echo e($user->name); ?>'s Cards
                </h2>
                <p class="text-sm text-gray-500">ID: <?php echo e($user->uuid); ?></p>
            </div>
            
            <button onclick="openCreateCardModal()"
                    class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2">
                <i class="ri-bank-card-line mr-2"></i>Create Card
            </button>
        </div>

       <?php if (isset($component)) { $__componentOriginal6912374916afbfe53350098c2f0b0678 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6912374916afbfe53350098c2f0b0678 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.session-status','data' => ['class' => 'mb-4','status' => session('status'),'errors' => $errors]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('session-status'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mb-4','status' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('status')),'errors' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6912374916afbfe53350098c2f0b0678)): ?>
<?php $attributes = $__attributesOriginal6912374916afbfe53350098c2f0b0678; ?>
<?php unset($__attributesOriginal6912374916afbfe53350098c2f0b0678); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6912374916afbfe53350098c2f0b0678)): ?>
<?php $component = $__componentOriginal6912374916afbfe53350098c2f0b0678; ?>
<?php unset($__componentOriginal6912374916afbfe53350098c2f0b0678); ?>
<?php endif; ?>

        <!-- Cards Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
            <?php $__empty_1 = true; $__currentLoopData = $user->cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="bg-white rounded-lg shadow-md overflow-hidden">
                    <div class="p-6 bg-gradient-to-r from-purple-500 to-purple-600">
                        <div class="flex justify-between items-start">
                            <div>
                                <p class="text-white text-lg font-medium mb-1">
                                    •••• •••• •••• <?php echo e($card->last_four); ?>

                                </p>
                                <p class="text-purple-100"><?php echo e($card->card_holder); ?></p>
                            </div>
                            <div class="flex items-center space-x-2">
                                <span class="px-2 py-1 text-xs rounded-full 
                                    <?php if($card->status === 'active'): ?> bg-green-100 text-green-800
                                    <?php elseif($card->status === 'frozen'): ?> bg-blue-100 text-blue-800
                                    <?php else: ?> bg-red-100 text-red-800 <?php endif; ?>">
                                    <?php echo e(ucfirst($card->status)); ?>

                                </span>
                                <span class="px-2 py-1 text-xs bg-purple-100 text-purple-800 rounded-full">
                                    <?php echo e(ucfirst($card->card_type)); ?>

                                </span>
                            </div>
                        </div>
                        <div class="mt-4">
                            <p class="text-purple-100 text-sm">Balance</p>
                            <p class="text-white text-2xl font-bold">$<?php echo e(number_format($card->balance, 2)); ?></p>
                        </div>
                    </div>

                    <div class="p-4 space-y-4">
                        <div class="grid grid-cols-2 gap-4 text-sm">
                            <div>
                                <p class="text-gray-500">Expiry Date</p>
                                <p class="font-medium"><?php echo e($card->expiry_month); ?>/<?php echo e($card->expiry_year); ?></p>
                            </div>
                            <div>
                                <p class="text-gray-500">Billing Address</p>
                                <p class="font-medium"><?php echo e($card->billing_address); ?></p>
                            </div>
                            <div>
                                <p class="text-gray-500">ZIP Code</p>
                                <p class="font-medium"><?php echo e($card->zip_code); ?></p>
                            </div>
                        </div>

                        <!-- Card Actions -->
                       <!-- Card Actions in your cards view -->
<div class="border-t pt-4">
    <div class="flex justify-between items-center">
        <div class="flex space-x-2">
            <button onclick="openFundCardModal('<?php echo e($card->id); ?>')"
                    class="px-3 py-1 text-xs text-white bg-green-600 rounded hover:bg-green-700">
                Add Funds
            </button>
            <button onclick="openSubtractCardModal('<?php echo e($card->id); ?>')"
                    class="px-3 py-1 text-xs text-white bg-red-600 rounded hover:bg-red-700">
                Subtract Funds
            </button>
        </div>
        <div class="flex space-x-2">
            <?php if($card->status === 'active'): ?>
                <form action="<?php echo e(route('admin.cards.freeze', $card)); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-3 py-1 text-xs text-white bg-blue-600 rounded hover:bg-blue-700">
                        Freeze Card
                    </button>
                </form>
                <form action="<?php echo e(route('admin.cards.deactivate', $card)); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-3 py-1 text-xs text-white bg-gray-600 rounded hover:bg-gray-700">
                        Deactivate Card
                    </button>
                </form>
            <?php elseif($card->status === 'frozen'): ?>
                <form action="<?php echo e(route('admin.cards.unfreeze', $card)); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-3 py-1 text-xs text-white bg-purple-600 rounded hover:bg-purple-700">
                        Unfreeze Card
                    </button>
                </form>
            <?php elseif($card->status === 'inactive'): ?>
                <form action="<?php echo e(route('admin.cards.activate', $card)); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-3 py-1 text-xs text-white bg-green-600 rounded hover:bg-green-700">
                        Activate Card
                    </button>
                </form>
            <?php endif; ?>
            
            <form action="<?php echo e(route('admin.cards.destroy', $card)); ?>" method="POST"
                  onsubmit="return confirm('Are you sure you want to delete this card?')" class="inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="px-3 py-1 text-xs text-white bg-red-600 rounded hover:bg-red-700">
                    Delete
                </button>
            </form>
        </div>
    </div>
</div>
                    </div>

                    <!-- Card Transactions -->
                    <div class="border-t">
                        <div class="p-4">
                            <h4 class="font-medium text-gray-700">Recent Transactions</h4>
                        </div>
                        <div class="max-h-64 overflow-y-auto">
                            <table class="w-full">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-4 py-2 text-xs font-medium text-gray-500 text-left">Date</th>
                                        <th class="px-4 py-2 text-xs font-medium text-gray-500 text-left">Description</th>
                                        <th class="px-4 py-2 text-xs font-medium text-gray-500 text-right">Amount</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y">
                                    <?php $__empty_2 = true; $__currentLoopData = $card->transactions()->latest()->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                        <tr>
                                            <td class="px-4 py-2 text-sm">
                                                <?php echo e($transaction->created_at->format('M d, Y H:i')); ?>

                                            </td>
                                            <td class="px-4 py-2 text-sm">
                                                <?php echo e($transaction->description); ?>

                                            </td>
                                            <td class="px-4 py-2 text-sm text-right">
                                                <span class="<?php echo e($transaction->amount > 0 ? 'text-green-600' : 'text-red-600'); ?>">
                                                    $<?php echo e(number_format($transaction->amount, 2)); ?>

                                                </span>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                        <tr>
                                            <td colspan="3" class="px-4 py-4 text-sm text-center text-gray-500">
                                                No transactions found
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-span-2 bg-white rounded-lg shadow-md p-6 text-center">
                    <p class="text-gray-500">No cards found for this user</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Create Card Modal -->
    <?php echo $__env->make('admin.cards.modals.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Fund Card Modal -->
    <?php echo $__env->make('admin.cards.modals.fund', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Subtract Card Modal -->
    <?php echo $__env->make('admin.cards.modals.subtract', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<script>
    function openCreateCardModal() {
        document.getElementById('createCardModal').classList.remove('hidden');
    }

    function closeCreateCardModal() {
        document.getElementById('createCardModal').classList.add('hidden');
    }

    function openFundCardModal(cardId) {
        const modal = document.getElementById('fundCardModal');
        const form = document.getElementById('fundCardForm');
        form.action = `/admin/cards/${cardId}/fund`;
        modal.classList.remove('hidden');
    }

    function closeFundCardModal() {
        document.getElementById('fundCardModal').classList.add('hidden');
    }

    function openSubtractCardModal(cardId) {
        const modal = document.getElementById('subtractCardModal');
        const form = document.getElementById('subtractCardForm');
        form.action = `/admin/cards/${cardId}/subtract`;
        modal.classList.remove('hidden');
    }

    function closeSubtractCardModal() {
        document.getElementById('subtractCardModal').classList.add('hidden');
    }
</script><?php /**PATH /home/safeweal/public_html/resources/views/admin/users/cards.blade.php ENDPATH**/ ?>