<!-- Create Transaction Modal -->
<div id="transactionModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-4xl">
            <div class="flex items-center justify-between p-6 border-b">
                <h3 class="text-lg font-semibold text-gray-900">Create Transaction</h3>
                <button type="button" onclick="closeTransactionModal()" class="text-gray-400 hover:text-gray-500">
                    <i class="ri-close-line text-xl"></i>
                </button>
            </div>

            <form action="<?php echo e(route('admin.transactions.store')); ?>" method="POST" class="p-6">
                <?php echo csrf_field(); ?>

                <!-- User Selection -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">User</label>
                    <select name="user_id" required
                            class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500">
                        <option value="">Select User</option>
                        <?php $__currentLoopData = \App\Models\User::orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>">
                                <?php echo e($user->name); ?> (<?php echo e($user->email); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Transaction Details -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- Transaction Type -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Transaction Type</label>
                        <select name="type" required onchange="handleTransactionTypeChange(this.value)"
                                class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500">
                            <option value="">Select Type</option>
                            <?php $__currentLoopData = App\Models\Transaction::getValidTypes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type); ?>"><?php echo e(ucfirst($type)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Crypto Selection -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Cryptocurrency</label>
                        <select name="which_crypto" required
                                class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                                onchange="updateAddressFields(this.value)">
                            <option value="">Select Cryptocurrency</option>
                            <?php $__currentLoopData = App\Models\CryptoAsset::getSupportedCryptos(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $symbol => $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($symbol); ?>"><?php echo e($crypto['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <!-- Swap Fields (Hidden by default) -->
                <div id="swapFields" class="grid grid-cols-2 gap-6 mb-6 hidden">
                    <!-- From Crypto -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">From Crypto</label>
                        <select name="from_crypto"
                                class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500">
                            <option value="">Select Cryptocurrency</option>
                            <?php $__currentLoopData = App\Models\CryptoAsset::getSupportedCryptos(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $symbol => $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($symbol); ?>"><?php echo e($crypto['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- To Crypto -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">To Crypto</label>
                        <select name="to_crypto"
                                class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500">
                            <option value="">Select Cryptocurrency</option>
                            <?php $__currentLoopData = App\Models\CryptoAsset::getSupportedCryptos(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $symbol => $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($symbol); ?>"><?php echo e($crypto['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <!-- Amount Fields -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- Amount In -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Amount In</label>
                        <input type="number" name="amount_in" step="0.00000001" required
                               class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="0.00000000">
                    </div>

                    <!-- Amount Out (for swaps) -->
                    <div id="amountOutField" class="hidden">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Amount Out</label>
                        <input type="number" name="amount_out" step="0.00000001"
                               class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="0.00000000">
                    </div>
                </div>

                <!-- Network Details -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- Network Fee -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Network Fee</label>
                        <input type="number" name="network_fee" step="0.00000001"
                               class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="0.00000000">
                    </div>

                    <!-- Rate -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Rate</label>
                        <input type="number" name="rate" step="0.00000001"
                               class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="0.00000000">
                    </div>
                </div>

                <!-- Transaction Hash & Status -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- Transaction Hash -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Transaction Hash</label>
                        <input type="text" name="transaction_hash"
                               class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="Enter transaction hash">
                    </div>

                    <!-- Status -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                        <select name="status" required
                                class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500">
                            <?php $__currentLoopData = App\Models\Transaction::getValidStatuses(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($status); ?>"><?php echo e(ucfirst($status)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <!-- Address Fields -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- From Address -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">From Address</label>
                        <input type="text" name="from_address" id="fromAddress"
                               class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="From address">
                    </div>

                    <!-- To Address -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">To Address</label>
                        <input type="text" name="to_address" id="toAddress"
                               class="w-full rounded-lg border-gray-300 focus:ring-purple-500 focus:border-purple-500"
                               placeholder="To address">
                    </div>
                </div>

                <!-- Submit Buttons -->
                <div class="flex justify-end space-x-3">
                    <button type="button" onclick="closeTransactionModal()"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-purple-500">
                        Cancel
                    </button>
                    <button type="submit"
                            class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500">
                        Create Transaction
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function openTransactionModal() {
        document.getElementById('transactionModal').classList.remove('hidden');
    }

    function closeTransactionModal() {
        document.getElementById('transactionModal').classList.add('hidden');
    }

    function handleTransactionTypeChange(value) {
        const swapFields = document.getElementById('swapFields');
        const amountOutField = document.getElementById('amountOutField');
        
        if (value === 'swap') {
            swapFields.classList.remove('hidden');
            amountOutField.classList.remove('hidden');
        } else {
            swapFields.classList.add('hidden');
            amountOutField.classList.add('hidden');
        }
    }

    async function updateAddressFields(crypto) {
        const user_id = document.querySelector('select[name="user_id"]').value;
        if (!user_id || !crypto) return;

        try {
            const response = await fetch(`/api/users/${user_id}/crypto-address/${crypto}`);
            const data = await response.json();
            
            if (data.address) {
                document.getElementById('fromAddress').value = data.address;
                // You might want to set the to_address based on some business logic
            }
        } catch (error) {
            console.error('Failed to fetch crypto address:', error);
        }
    }
</script><?php /**PATH /home/elitemaxpro/wallet.elitemaxpro.click/resources/views/admin/transactions/modals/create.blade.php ENDPATH**/ ?>