<aside id="leftSidebar" class="hidden md:flex flex-col w-64 bg-white h-screen fixed left-0 top-0 overflow-y-auto shadow-lg z-50">
    <!-- Header with gradient -->
    <div class="bg-gradient-to-r from-blue-500 to-blue-700 py-6 px-6">
        <a href="<?php echo e(route('dashboard')); ?>" class="text-xl font-bold text-white flex items-center gap-2">
            <i class="fas fa-wallet"></i>
            <span><?php echo e(config('app.name', 'Crypto Wallet')); ?></span>
        </a>
        <div class="mt-2 text-blue-100 text-sm opacity-80">Secure & Simple Crypto Wallet</div>
    </div>

    <!-- Account Section -->
    <div class="px-4 py-4 border-b border-gray-100">
        <div class="flex items-center gap-3 p-2 hover:bg-blue-50 rounded-xl transition-all duration-200">
            <div class="bg-blue-100 h-10 w-10 rounded-full flex items-center justify-center text-blue-600">
                <i class="fas fa-user"></i>
            </div>
            <div class="overflow-hidden">
                <div class="text-sm font-medium text-trust-text whitespace-nowrap overflow-hidden text-ellipsis" id="sidebarAccountId">
                    <?php echo e($accountId ?? 'My Wallet'); ?>

                </div>
                <div class="text-xs text-trust-text-secondary flex items-center gap-1">
                    <span class="w-2 h-2 rounded-full bg-green-500"></span>
                    <span>Connected</span>
                </div>
            </div>
        </div>
    </div>

    <div class="px-4 py-4">
        <!-- Menu Section -->
        <div class="mb-8">
            <h2 class="text-trust-blue text-xs font-bold uppercase tracking-wider mb-3 pl-2">Menu</h2>
            <nav class="space-y-1">
                <a href="<?php echo e(route('dashboard')); ?>" 
                   class="group flex items-center text-trust-text px-3 py-2.5 rounded-xl transition-all duration-200
                   <?php echo e(request()->routeIs('dashboard') ? 'bg-blue-50 text-blue-600 font-medium' : 'hover:bg-gray-50'); ?>">
                    <div class="w-8 h-8 mr-3 rounded-lg flex items-center justify-center transition-all duration-200 
                    <?php echo e(request()->routeIs('dashboard') ? 'bg-blue-100' : 'bg-gray-100 group-hover:bg-blue-50'); ?>">
                        <i class="fas fa-home w-4 h-4 <?php echo e(request()->routeIs('dashboard') ? 'text-blue-600' : 'text-trust-text-secondary group-hover:text-blue-500'); ?>"></i>
                    </div>
                    <span>Wallet</span>
                </a>

                <a href="<?php echo e(route('swap')); ?>" 
                   class="group flex items-center text-trust-text px-3 py-2.5 rounded-xl transition-all duration-200
                   <?php echo e(request()->routeIs('swap') ? 'bg-blue-50 text-blue-600 font-medium' : 'hover:bg-gray-50'); ?>">
                    <div class="w-8 h-8 mr-3 rounded-lg flex items-center justify-center transition-all duration-200 
                    <?php echo e(request()->routeIs('swap') ? 'bg-blue-100' : 'bg-gray-100 group-hover:bg-blue-50'); ?>">
                        <i class="fas fa-arrows-rotate w-4 h-4 <?php echo e(request()->routeIs('swap') ? 'text-blue-600' : 'text-trust-text-secondary group-hover:text-blue-500'); ?>"></i>
                    </div>
                    <span>DEX</span>
                </a>

                <a onclick="toggleModal('sendModal')"
                   class="group flex items-center text-trust-text px-3 py-2.5 rounded-xl transition-all duration-200 hover:bg-gray-50 cursor-pointer">
                    <div class="w-8 h-8 mr-3 rounded-lg bg-gray-100 flex items-center justify-center transition-all duration-200 group-hover:bg-blue-50">
                        <i class="fas fa-arrow-up w-4 h-4 text-trust-text-secondary group-hover:text-blue-500"></i>
                    </div>
                    <span>Send</span>
                </a>

                <a onclick="toggleModal('receiveModal')" 
                   class="group flex items-center text-trust-text px-3 py-2.5 rounded-xl transition-all duration-200 hover:bg-gray-50 cursor-pointer">
                    <div class="w-8 h-8 mr-3 rounded-lg bg-gray-100 flex items-center justify-center transition-all duration-200 group-hover:bg-blue-50">
                        <i class="fas fa-arrow-down w-4 h-4 text-trust-text-secondary group-hover:text-blue-500"></i>
                    </div>
                    <span>Receive</span>
                </a>

                <a href="<?php echo e(route('referral.index')); ?>" 
                   class="group flex items-center text-trust-text px-3 py-2.5 rounded-xl transition-all duration-200
                   <?php echo e(request()->routeIs('referral.index') ? 'bg-blue-50 text-blue-600 font-medium' : 'hover:bg-gray-50'); ?>">
                    <div class="w-8 h-8 mr-3 rounded-lg flex items-center justify-center transition-all duration-200 
                    <?php echo e(request()->routeIs('referral.index') ? 'bg-blue-100' : 'bg-gray-100 group-hover:bg-blue-50'); ?>">
                        <i class="fas fa-users w-4 h-4 <?php echo e(request()->routeIs('referral.index') ? 'text-blue-600' : 'text-trust-text-secondary group-hover:text-blue-500'); ?>"></i>
                    </div>
                    <span>Referrals</span>
                </a>

                <a href="<?php echo e(route('settings')); ?>" 
                   class="group flex items-center text-trust-text px-3 py-2.5 rounded-xl transition-all duration-200
                   <?php echo e(request()->routeIs('settings') ? 'bg-blue-50 text-blue-600 font-medium' : 'hover:bg-gray-50'); ?>">
                    <div class="w-8 h-8 mr-3 rounded-lg flex items-center justify-center transition-all duration-200 
                    <?php echo e(request()->routeIs('settings') ? 'bg-blue-100' : 'bg-gray-100 group-hover:bg-blue-50'); ?>">
                        <i class="fas fa-cog w-4 h-4 <?php echo e(request()->routeIs('settings') ? 'text-blue-600' : 'text-trust-text-secondary group-hover:text-blue-500'); ?>"></i>
                    </div>
                    <span>Settings</span>
                </a>
            </nav>
        </div>

        <!-- Crypto Section -->
        <div class="mb-8">
            <h2 class="text-trust-blue text-xs font-bold uppercase tracking-wider mb-3 pl-2">Crypto</h2>
            <div class="space-y-1">
                <a href="<?php echo e(route('crypto.manage')); ?>" 
                   class="group flex items-center text-trust-text px-3 py-2.5 rounded-xl transition-all duration-200
                   <?php echo e(request()->routeIs('crypto.manage') ? 'bg-blue-50 text-blue-600 font-medium' : 'hover:bg-gray-50'); ?>">
                    <div class="w-8 h-8 mr-3 rounded-lg flex items-center justify-center transition-all duration-200 
                    <?php echo e(request()->routeIs('crypto.manage') ? 'bg-blue-100' : 'bg-gray-100 group-hover:bg-blue-50'); ?>">
                        <i class="fas fa-layer-group w-4 h-4 <?php echo e(request()->routeIs('crypto.manage') ? 'text-blue-600' : 'text-trust-text-secondary group-hover:text-blue-500'); ?>"></i>
                    </div>
                    <span>Manage Crypto</span>
                </a>

                <a href="<?php echo e(route('crypto.address')); ?>" 
                   class="group flex items-center text-trust-text px-3 py-2.5 rounded-xl transition-all duration-200
                   <?php echo e(request()->routeIs('crypto.address') ? 'bg-blue-50 text-blue-600 font-medium' : 'hover:bg-gray-50'); ?>">
                    <div class="w-8 h-8 mr-3 rounded-lg flex items-center justify-center transition-all duration-200 
                    <?php echo e(request()->routeIs('crypto.address') ? 'bg-blue-100' : 'bg-gray-100 group-hover:bg-blue-50'); ?>">
                        <i class="fas fa-address-card w-4 h-4 <?php echo e(request()->routeIs('crypto.address') ? 'text-blue-600' : 'text-trust-text-secondary group-hover:text-blue-500'); ?>"></i>
                    </div>
                    <span>Crypto Address</span>
                </a>

                <a href="<?php echo e(route('notifications')); ?>" 
                   class="group relative flex items-center text-trust-text px-3 py-2.5 rounded-xl transition-all duration-200
                   <?php echo e(request()->routeIs('notifications') ? 'bg-blue-50 text-blue-600 font-medium' : 'hover:bg-gray-50'); ?>">
                    <div class="w-8 h-8 mr-3 rounded-lg flex items-center justify-center transition-all duration-200 
                    <?php echo e(request()->routeIs('notifications') ? 'bg-blue-100' : 'bg-gray-100 group-hover:bg-blue-50'); ?>">
                        <i class="fas fa-bell w-4 h-4 <?php echo e(request()->routeIs('notifications') ? 'text-blue-600' : 'text-trust-text-secondary group-hover:text-blue-500'); ?>"></i>
                    </div>
                    <span>Notifications</span>
                    <span id="sidebar-notification-badge" class="absolute top-2 right-3 bg-red-500 text-white text-xs rounded-full w-4 h-4 flex items-center justify-center hidden">
                        0
                    </span>
                </a>
            </div>
        </div>
    </div>

    <!-- Sidebar footer with status -->
    <div class="mt-auto p-4 border-t border-gray-100">
        <div class="flex items-center justify-between text-xs text-trust-text-secondary p-2">
            <div class="flex items-center gap-1">
                <span class="w-2 h-2 rounded-full bg-green-500"></span>
                <span>Online</span>
            </div>
        </div>
    </div>
</aside><?php /**PATH /home/neosafewallet/public_html/resources/views/layouts/user/sidebar.blade.php ENDPATH**/ ?>