<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Referrals')]); ?>
    <div id="toast" class="fixed top-4 right-4 z-50 bg-blue-500 text-white px-6 py-3 rounded-xl shadow-lg transform translate-x-full transition-transform duration-300 ease-in-out hidden opacity-90">
        <div class="flex items-center">
            <i class="fas fa-check-circle mr-2"></i>
            Link copied to clipboard!
        </div>
    </div>
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-white text-gray-900 transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <a href="<?php echo e(route('settings')); ?>" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">Referrals</h1>
            <div class="w-8"></div>
        </div>

        <!-- Referral Stats Card -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-6">
            <div class="grid grid-cols-2 gap-4">
                <div class="text-center">
                    <div class="w-12 h-12 rounded-full bg-blue-50 flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-users text-blue-500"></i>
                    </div>
                    <p class="text-gray-500 text-sm mb-1">Total Referrals</p>
                    <p class="text-2xl font-medium text-gray-900"><?php echo e($referral_count); ?></p>
                </div>
                <div class="text-center">
                    <div class="w-12 h-12 rounded-full bg-blue-50 flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-calendar-alt text-blue-500"></i>
                    </div>
                    <p class="text-gray-500 text-sm mb-1">This Month</p>
                    <p class="text-2xl font-medium text-gray-900">
                        <?php echo e($referrals->whereBetween('created_at', [now()->startOfMonth(), now()])->count()); ?>

                    </p>
                </div>
            </div>
        </div>

        <!-- Referral Link Card -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-6">
            <h2 class="text-lg font-medium mb-4">Your Referral Link</h2>
            <div class="relative">
                <input 
                    type="text" 
                    value="<?php echo e($referral_link); ?>" 
                    class="w-full bg-gray-50 border border-gray-200 rounded-xl px-4 py-3 pr-12 text-sm text-gray-900"
                    readonly
                >
                <button 
                    onclick="copyToClipboard('<?php echo e($referral_link); ?>')"
                    class="absolute right-3 top-1/2 transform -translate-y-1/2 w-8 h-8 rounded-full bg-blue-50 flex items-center justify-center text-blue-500 hover:bg-blue-100 transition-colors"
                >
                    <i class="fas fa-copy"></i>
                </button>
            </div>
            <p class="text-sm text-gray-500 mt-3">
                Share this link with friends to earn rewards
            </p>
        </div>

        <!-- Share Button -->
        <div class="mb-6">
            <button onclick="shareReferralLink()" class="w-full bg-blue-500 hover:bg-blue-600 text-white font-medium py-3 px-4 rounded-xl transition-colors flex items-center justify-center">
                <i class="fas fa-share-alt mr-2"></i>
                Share Your Referral Link
            </button>
        </div>

        <!-- Recent Referrals -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <h2 class="text-lg font-medium mb-4">Recent Referrals</h2>
            <?php if($referrals->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between py-3 border-b border-gray-100">
                            <div class="flex items-center">
                                <div class="w-10 h-10 rounded-full bg-blue-50 flex items-center justify-center mr-3">
                                    <i class="fas fa-user text-blue-500"></i>
                                </div>
                                <div>
                                    <p class="font-medium text-gray-900"><?php echo e($referral->name); ?></p>
                                    <p class="text-sm text-gray-500">
                                        Joined <?php echo e($referral->created_at->diffForHumans()); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <div class="w-16 h-16 rounded-full bg-gray-100 flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-users text-2xl text-gray-400"></i>
                    </div>
                    <p class="text-gray-600 font-medium">No referrals yet</p>
                    <p class="text-sm text-gray-500 mt-1">Share your referral link to get started</p>
                </div>
            <?php endif; ?>
        </div>
    </main>

    <script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(() => {
            const toast = document.getElementById('toast');
            toast.classList.remove('hidden');
            // Add small delay to ensure transition works properly
            setTimeout(() => {
                toast.classList.remove('translate-x-full');
            }, 10);
            
            // Add subtle animation to copy button
            const copyButton = document.querySelector('button[onclick="copyToClipboard(\'<?php echo e($referral_link); ?>\')"]');
            copyButton.innerHTML = '<i class="fas fa-check"></i>';
            copyButton.classList.add('bg-green-100');
            copyButton.classList.add('text-green-500');
            
            // Restore copy button after 2 seconds
            setTimeout(() => {
                copyButton.innerHTML = '<i class="fas fa-copy"></i>';
                copyButton.classList.remove('bg-green-100');
                copyButton.classList.remove('text-green-500');
            }, 2000);
            
            // Hide toast after 3 seconds
            setTimeout(() => {
                toast.classList.add('translate-x-full');
                // Hide element after transition completes
                setTimeout(() => {
                    toast.classList.add('hidden');
                }, 300);
            }, 3000);
        }).catch(err => {
            console.error('Failed to copy text: ', err);
        });
    }
    
    function shareReferralLink() {
        const referralLink = "<?php echo e($referral_link); ?>";
        
        // Check if Web Share API is supported
        if (navigator.share) {
            navigator.share({
                title: 'Join with my referral link',
                text: 'Use my referral link to join:',
                url: referralLink
            })
            .catch(err => {
                console.error('Share failed:', err);
                // Fallback to copy if sharing fails
                copyToClipboard(referralLink);
            });
        } else {
            // Fallback for browsers that don't support Web Share API
            copyToClipboard(referralLink);
        }
    }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?><?php /**PATH /home/theqfsecuredledg/public_html/resources/views/user/referral/index.blade.php ENDPATH**/ ?>