<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($subject); ?></title>
    <style>
        /* Base Styles */
        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 16px;
            line-height: 1.6;
            color: #333;
            background-color: #f7f7f7;
        }
        
        /* Container */
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }
        
        /* Header */
        .header {
            padding: 20px;
            text-align: center;
            background-color: #6b21a8;
            color: white;
        }
        
        .header img {
            max-height: 60px;
            margin-bottom: 10px;
        }
        
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        
        /* Content */
        .content {
            padding: 30px 20px;
        }
        
        /* Personal Greeting */
        .greeting {
            font-weight: 600;
            margin-bottom: 20px;
            color: #111;
        }
        
        /* Main Content */
        .main-content {
            color: #444;
        }
        
        .main-content img {
            max-width: 100%;
            height: auto;
            margin: 10px 0;
        }
        
        /* Call to Action Button */
        .cta-button {
            display: inline-block;
            padding: 12px 24px;
            margin: 20px 0;
            background-color: #6b21a8;
            color: white;
            text-decoration: none;
            font-weight: 500;
            border-radius: 4px;
        }
        
        /* Footer */
        .footer {
            padding: 20px;
            text-align: center;
            background-color: #f1f1f1;
            color: #666;
            font-size: 14px;
            border-top: 1px solid #e5e5e5;
        }
        
        .footer p {
            margin: 5px 0;
        }
        
        .social-links {
            margin: 15px 0;
        }
        
        .social-links a {
            display: inline-block;
            margin: 0 5px;
            color: #6b21a8;
            text-decoration: none;
        }
        
        .unsubscribe {
            color: #999;
            font-size: 12px;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .container {
                width: 100% !important;
            }
            
            .content {
                padding: 20px 15px;
            }
            
            .header h1 {
                font-size: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <?php if($companyLogo): ?>
                <img src="<?php echo e(asset($companyLogo)); ?>" alt="<?php echo e($companyName); ?> Logo">
            <?php endif; ?>
            <h1><?php echo e($companyName); ?></h1>
        </div>
        
        <div class="content">
            <div class="greeting">
                Hello <?php echo e($user->name); ?>,
            </div>
            
            <div class="main-content">
                <?php echo $content; ?>

            </div>
        </div>
        
        <div class="footer">
            <div class="social-links">
                <a href="#">Twitter</a> |
                <a href="#">Facebook</a> |
                <a href="#">Instagram</a>
            </div>
            
            <p>© <?php echo e(date('Y')); ?> <?php echo e($companyName); ?>. All rights reserved.</p>
            <p>For support, contact us at <?php echo e($companyEmail); ?></p>
            
            <p class="unsubscribe">
                If you no longer wish to receive these emails, you can <a href="#">unsubscribe</a>.
            </p>
        </div>
    </div>
</body>
</html> <?php /**PATH /home/safeweal/public_html/resources/views/emails/newsletter/standard.blade.php ENDPATH**/ ?>