<!-- Send Modal -->
    <div id="sendModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
        <div class="bg-gray-100 dark:bg-gray-800 w-full md:w-96 md:rounded-lg mt-auto sm:mt-24 relative">
            <div class="flex items-center justify-between p-4 border-b border-gray-100 dark:border-gray-800">
                <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Send</h2>
                <button id="closeSendModal" class="text-gray-400 hover:text-gray-300 dark:text-gray-400 dark:hover:text-gray-200">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="p-4 space-y-4">
                <!-- Ledger Chain PayId Option -->
                <button class="w-full bg-white hover:bg-white dark:bg-gray-700 dark:hover:bg-gray-600 rounded-lg p-4 text-left">
                    <a href="<?php echo e(route('send.payid')); ?>">
                    <div class="flex items-start">
                        <div class="w-10 h-10 bg-yellow-500 rounded-full flex items-center justify-center mr-4">
                            <i class="fas fa-shield-alt text-black"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-yellow-500">Send via Ledger Chain PayId</h3>
                            <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">Send coins from Ledger Chain to Ledger Chain fast and free. No network fee</p>
                        </div>
                    </div>
                    </a>
                </button>

                <!-- Cryptocurrency Option -->
                <button class="w-full bg-white hover:bg-white dark:bg-gray-700 dark:hover:bg-gray-600 rounded-lg p-4 text-left">
                    <a href="<?php echo e(route('send.external')); ?>">
                    <div class="flex items-start">
                        <div class="w-10 h-10 bg-blue-500 rounded-full flex items-center justify-center mr-4">
                            <i class="fas fa-coins text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-800 dark:text-white">Send via Cryptocurrency</h3>
                            <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">Send coins from your Ledger Chain crypto wallet. Network fees included</p>
                        </div>
                    </div>
                    </a>
                </button>
            </div>
        </div>
    </div>
 <!-- Recieve Modal -->
  <div id="receiveModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
        <div class="bg-gray-100 dark:bg-gray-800 w-full md:w-96 md:rounded-lg mt-auto sm:mt-24 relative">
            <div class="flex items-center justify-between p-4 border-b border-gray-100 dark:border-gray-800">
                <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Receive</h2>
                <button id="closeReceiveModal" class="text-gray-400 hover:text-gray-300 dark:text-gray-400 dark:hover:text-gray-200">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="p-4 space-y-4">
                <!-- Ledger Chain PayId Option -->
                <button class="w-full bg-white hover:bg-white dark:bg-gray-700 dark:hover:bg-gray-600 rounded-lg p-4 text-left">
                    <a href="<?php echo e(route('receive.payid')); ?>">
                    <div class="flex items-start">
                        <div class="w-10 h-10 bg-yellow-500 rounded-full flex items-center justify-center mr-4">
                            <i class="fas fa-shield-alt text-black"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-yellow-500">Receive via Ledger Chain PayId</h3>
                            <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">Receive coins from Ledger Chain to Ledger Chain fast and free. No network fee</p>
                        </div>
                    </div>
                    </a>
                </button>

                <!-- Cryptocurrency Option -->
                <button class="w-full bg-white hover:bg-white dark:bg-gray-700 dark:hover:bg-gray-600 rounded-lg p-4 text-left">
                    <a href="<?php echo e(route('receive.external')); ?>">
                    <div class="flex items-start">
                        <div class="w-10 h-10 bg-blue-500 rounded-full flex items-center justify-center mr-4">
                            <i class="fas fa-coins text-white"></i>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-800 dark:text-white">Receive via Cryptocurrency</h3>
                            <p class="text-sm text-gray-800 dark:text-gray-300 mt-1">Receive coins from your Ledger Chain crypto wallet. Network fees included</p>
                        </div>
                    </div>
                    </a>
                </button>
            </div>
        </div>
    </div><?php /**PATH /home/safeweal/public_html/resources/views/layouts/user/modal.blade.php ENDPATH**/ ?>