<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="w-full mx-auto min-h-screen bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between p-4">
            <button wire:navigate href="<?php echo e(route('dashboard')); ?>" class="text-gray-400 hover:text-gray-300">
                <i class="fas fa-arrow-left text-xl"></i>
            </button>
            <h1 class="text-xl font-semibold">Send via PayID</h1>
            <div class="w-8"><!-- Empty div for alignment --></div>
        </div>

        <!-- Search and Filter -->
        <div class="p-4 space-y-4">
            <!-- Search Bar -->
            <div class="relative">
                <i class="fas fa-search absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-500"></i>
                <input 
                    type="text" 
                    placeholder="Enter coin name" 
                    class="w-full bg-transparent border border-gray-700 rounded-full py-2 pl-12 pr-4 text-white placeholder-gray-500 focus:outline-none focus:border-gray-600"
                >
            </div>

            <!-- Network Filter -->
            <div>
                <span class="inline-block px-4 py-1 rounded-full text-sm bg-gray-100 border border-gray-800 dark:bg-gray-800 text-gray:800 dark:text-white">
                    All Networks
                </span>
            </div>
        </div>

        <!-- Crypto List -->
        <div class="space-y-4 p-4">
            <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('send.payid.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native'])); ?>" 
                   class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="relative">
                            <?php if($asset['icon_url']): ?>
                                <img src="<?php echo e($asset['icon_url']); ?>" alt="<?php echo e($asset['symbol']); ?>" class="w-10 h-10 rounded-full">
                                <?php if(!empty($asset['network_url'])): ?>
                                    <img src="<?php echo e($asset['network_url']); ?>" 
                                         alt="<?php echo e($asset['network']); ?>" 
                                         class="absolute border border-light" 
                                         style="width: 15px; height: auto; bottom: 0; right: 0; background: white; border-radius: 50%;">
                                <?php endif; ?>
                            <?php else: ?>
                                <div class="w-10 h-10 bg-gray-500 rounded-full flex items-center justify-center">
                                    <span class="text-white font-bold"><?php echo e($asset['symbol']); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="ml-3">
                            <div class="flex items-center">
                                <span class="font-semibold mr-2"><?php echo e($asset['symbol']); ?></span>
                                <?php if($asset['network']): ?>
                                    <span class="text-xs bg-white dark:bg-gray-800 px-2 py-0.5 rounded"><?php echo e($asset['network']); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="flex items-center text-sm">
                                <span class="text-gray-400 mr-2">$<?php echo e(number_format($asset['price'], 2)); ?></span>
                                <span class="<?php if(str_starts_with($asset['change'], '-')): ?> text-red-500 <?php else: ?> text-green-500 <?php endif; ?>">
                                    <?php echo e($asset['change']); ?>%
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="font-semibold"><?php echo e(number_format($asset['balance'], 4)); ?></div>
                        <div class="text-sm text-gray-400">$<?php echo e(number_format($asset['value'], 2)); ?></div>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?><?php /**PATH /home/safeweal/public_html/resources/views/user/send/assets-payid.blade.php ENDPATH**/ ?>