<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Referrals')]); ?>
 <div id="toast" class="fixed top-4 right-4 z-50 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg transform translate-x-full transition-transform duration-300 ease-in-out hidden">
        Link copied to clipboard!
    </div>
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8 pb-4">
            <a href="<?php echo e(route('settings')); ?>" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">Referrals</h1>
            <div class="w-8"></div>
        </div>

        <!-- Referral Stats Card -->
        <div class="bg-white dark:bg-dark-800 rounded-xl shadow-sm p-6 mb-6">
            <div class="grid grid-cols-2 gap-4 mb-6">
                <div class="text-center">
                    <p class="text-gray-600 dark:text-gray-400 text-sm">Total Referrals</p>
                    <p class="text-2xl font-bold text-yellow-500"><?php echo e($referral_count); ?></p>
                </div>
                <div class="text-center">
                    <p class="text-gray-600 dark:text-gray-400 text-sm">This Month</p>
                    <p class="text-2xl font-bold text-yellow-500">
                        <?php echo e($referrals->whereBetween('created_at', [now()->startOfMonth(), now()])->count()); ?>

                    </p>
                </div>
            </div>
        </div>

        <!-- Referral Link Card -->
        <div class="bg-white dark:bg-dark-800 rounded-xl shadow-sm p-6 mb-6">
            <h2 class="text-lg font-semibold mb-4">Your Referral Link</h2>
            <div class="relative">
                <input 
                    type="text" 
                    value="<?php echo e($referral_link); ?>" 
                    class="w-full bg-gray-50 dark:bg-gray-700/50 border border-gray-200 dark:border-gray-600 rounded-xl px-4 py-3 pr-12 text-sm text-gray-900 dark:text-gray-100"
                    readonly
                >
                <button 
                    onclick="copyToClipboard('<?php echo e($referral_link); ?>')"
                    class="absolute right-2 top-1/2 transform -translate-y-1/2 text-yellow-500 hover:text-yellow-600 dark:hover:text-yellow-400"
                >
                    <i class="fas fa-copy"></i>
                </button>
            </div>
            <p class="text-sm text-gray-600 dark:text-gray-400 mt-2">
                Share this link with friends to earn rewards
            </p>
        </div>

        <!-- Recent Referrals -->
        <div class="bg-white dark:bg-dark-800 rounded-xl shadow-sm p-6">
            <h2 class="text-lg font-semibold mb-4">Recent Referrals</h2>
            <?php if($referrals->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-between py-3 border-b border-gray-200 dark:border-gray-700">
                            <div class="flex items-center">
                                <div class="bg-yellow-100 dark:bg-yellow-900/30 rounded-full p-2 mr-3">
                                    <i class="fas fa-user text-yellow-500"></i>
                                </div>
                                <div>
                                    <p class="font-medium"><?php echo e($referral->name); ?></p>
                                    <p class="text-sm text-gray-600 dark:text-gray-400">
                                        Joined <?php echo e($referral->created_at->diffForHumans()); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <div class="bg-gray-100 dark:bg-gray-800 rounded-full p-3 w-16 h-16 flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-users text-2xl text-gray-400"></i>
                    </div>
                    <p class="text-gray-600 dark:text-gray-400">No referrals yet</p>
                    <p class="text-sm text-gray-500 dark:text-gray-500 mt-1">Share your referral link to get started</p>
                </div>
            <?php endif; ?>
        </div>
    </main>

    <script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(() => {
            const toast = document.getElementById('toast');
            toast.classList.remove('hidden');
            // Add small delay to ensure transition works properly
            setTimeout(() => {
                toast.classList.remove('translate-x-full');
            }, 10);
            
            // Hide toast after 3 seconds
            setTimeout(() => {
                toast.classList.add('translate-x-full');
                // Hide element after transition completes
                setTimeout(() => {
                    toast.classList.add('hidden');
                }, 300);
            }, 3000);
        }).catch(err => {
            console.error('Failed to copy text: ', err);
        });
    }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?><?php /**PATH /home/cypherva/public_html/resources/views/user/referral/index.blade.php ENDPATH**/ ?>