<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($subject); ?></title>
    <style>
        /* Base Styles */
        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 16px;
            line-height: 1.6;
            color: #333;
            background-color: #f7f7f7;
        }
        
        /* Container */
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
        
        /* Header */
        .header {
            padding: 30px 20px;
            text-align: center;
            background: linear-gradient(135deg, #6b21a8 0%, #4c1d95 100%);
            color: white;
            border-bottom: 5px solid #f97316;
        }
        
        .header img {
            max-height: 70px;
            margin-bottom: 15px;
        }
        
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .header p {
            margin: 10px 0 0;
            font-size: 18px;
            opacity: 0.9;
        }
        
        /* Content */
        .content {
            padding: 30px 20px;
        }
        
        /* Announcement Banner */
        .announcement-banner {
            background-color: #fff9db;
            border-left: 4px solid #f97316;
            padding: 15px;
            margin-bottom: 25px;
        }
        
        .announcement-label {
            font-weight: 700;
            color: #f97316;
            display: block;
            margin-bottom: 5px;
            text-transform: uppercase;
            font-size: 14px;
            letter-spacing: 1px;
        }
        
        /* Personal Greeting */
        .greeting {
            font-weight: 600;
            margin-bottom: 20px;
            color: #111;
        }
        
        /* Main Content */
        .main-content {
            color: #444;
        }
        
        .main-content img {
            max-width: 100%;
            height: auto;
            margin: 15px 0;
            border-radius: 4px;
        }
        
        /* Call to Action Button */
        .cta-container {
            text-align: center;
            margin: 30px 0;
        }
        
        .cta-button {
            display: inline-block;
            padding: 14px 28px;
            background-color: #f97316;
            color: white;
            text-decoration: none;
            font-weight: 600;
            border-radius: 4px;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-size: 14px;
            transition: background-color 0.3s;
        }
        
        /* Footer */
        .footer {
            padding: 25px 20px;
            text-align: center;
            background-color: #f1f1f1;
            color: #666;
            font-size: 14px;
            border-top: 1px solid #e5e5e5;
        }
        
        .footer p {
            margin: 5px 0;
        }
        
        .social-links {
            margin: 15px 0;
        }
        
        .social-links a {
            display: inline-block;
            margin: 0 5px;
            color: #6b21a8;
            text-decoration: none;
            font-weight: 500;
        }
        
        .unsubscribe {
            color: #999;
            font-size: 12px;
            margin-top: 15px;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .container {
                width: 100% !important;
            }
            
            .content {
                padding: 20px 15px;
            }
            
            .header {
                padding: 20px 15px;
            }
            
            .header h1 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <?php if($companyLogo): ?>
                <img src="<?php echo e(asset($companyLogo)); ?>" alt="<?php echo e($companyName); ?> Logo">
            <?php endif; ?>
            <h1>Important Announcement</h1>
            <p><?php echo e($subject); ?></p>
        </div>
        
        <div class="content">
            <div class="announcement-banner">
                <span class="announcement-label">Attention</span>
                <strong>Please read this important announcement from <?php echo e($companyName); ?></strong>
            </div>
            
            <div class="greeting">
                Dear <?php echo e($user->name); ?>,
            </div>
            
            <div class="main-content">
                <?php echo $content; ?>

            </div>
            
            <div class="cta-container">
                <a href="#" class="cta-button">Learn More</a>
            </div>
        </div>
        
        <div class="footer">
            <div class="social-links">
                <a href="#">Twitter</a> |
                <a href="#">Facebook</a> |
                <a href="#">Instagram</a>
            </div>
            
            <p>© <?php echo e(date('Y')); ?> <?php echo e($companyName); ?>. All rights reserved.</p>
            <p>For support, contact us at <?php echo e($companyEmail); ?></p>
            
            <p class="unsubscribe">
                If you no longer wish to receive these emails, you can <a href="#">unsubscribe</a>.
            </p>
        </div>
    </div>
</body>
</html> <?php /**PATH /home/safeweal/public_html/resources/views/emails/newsletter/announcement.blade.php ENDPATH**/ ?>