<x-user-layout :title="$asset['symbol']">
    <main class="md:pb-4 bg-white text-gray-900 transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between p-4 mb-4">
            <a href="{{ route('dashboard') }}" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <div class="text-center">
                <h1 class="text-xl font-semibold">{{ $asset['symbol'] }}</h1>
                @if($asset['network'])
                    <p class="text-gray-500 text-sm">{{ $asset['symbol'] }} | {{ $asset['network'] }}</p>
                @else
                    <p class="text-gray-500 text-sm">{{ $asset['symbol'] }} | {{ ucfirst($coinId) }}</p>
                @endif
            </div>
            <button class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-chart-line text-xl"></i>
            </button>
        </div>

        <!-- Asset Icon and Balance -->
        <div class="flex flex-col items-center mx-6 mb-8">
            <div class="relative mb-6">
                @if($asset['icon_url'])
                    <div class="w-20 h-20 rounded-full bg-blue-50 flex items-center justify-center">
                        <img src="{{ $asset['icon_url'] }}" alt="{{ $asset['symbol'] }}" class="w-14 h-14">
                        @if(!empty($asset['network_url']))
                            <div class="absolute right-0 bottom-0 border-2 border-white rounded-full bg-white">
                                <img src="{{ $asset['network_url'] }}" 
                                     alt="{{ $asset['network'] }}" 
                                     class="w-7 h-7 rounded-full">
                            </div>
                        @endif
                    </div>
                @else
                    <div class="w-20 h-20 bg-blue-50 rounded-full flex items-center justify-center">
                        <span class="text-2xl text-blue-500 font-bold">{{ $asset['symbol'] }}</span>
                    </div>
                @endif
            </div>
            
            <h2 class="text-3xl font-medium mb-1">{{ number_format($asset['balance'], 8) }} {{ $asset['symbol'] }}</h2>
            <p class="text-gray-500 text-lg">${{ number_format($asset['value'], 2) }}</p>
        </div>

        <!-- Action Buttons -->
        <div class="grid grid-cols-4 gap-4 mb-8 px-6">
            <div class="flex flex-col items-center">
                <button onclick="openAssetSendModal()" 
                        class="w-14 h-14 rounded-full bg-blue-50 hover:bg-blue-100 flex items-center justify-center mb-2 transition-colors">
                    <i class="fas fa-arrow-up text-blue-500 text-lg"></i>
                </button>
                <span class="text-sm text-gray-600">Send</span>
            </div>
            <div class="flex flex-col items-center">
                <button onclick="openAssetReceiveModal()" 
                        class="w-14 h-14 rounded-full bg-blue-50 hover:bg-blue-100 flex items-center justify-center mb-2 transition-colors">
                    <i class="fas fa-arrow-down text-blue-500 text-lg"></i>
                </button>
                <span class="text-sm text-gray-600">Receive</span>
            </div>
            <div class="flex flex-col items-center">
                <a href="{{ route('buy.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native']) }}" 
                        class="w-14 h-14 rounded-full bg-blue-50 hover:bg-blue-100 flex items-center justify-center mb-2 transition-colors">
                    <i class="fas fa-credit-card text-blue-500 text-lg"></i>
                </a>
                <span class="text-sm text-gray-600">Buy</span>
            </div>
            <div class="flex flex-col items-center">
                <a href="{{ route('swap') }}" 
                        class="w-14 h-14 rounded-full bg-blue-50 hover:bg-blue-100 flex items-center justify-center mb-2 transition-colors">
                    <i class="fas fa-exchange-alt text-blue-500 text-lg"></i>
                </a>
                <span class="text-sm text-gray-600">Swap</span>
            </div>
        </div>

        <!-- Transactions Section -->
        <div class="px-4">
            <div class="flex border-b border-gray-200 mb-4">
                <button class="text-blue-500 font-medium pb-2 border-b-2 border-blue-500 mr-6">
                    Transactions
                </button>
            </div>

            <!-- Transaction List -->
            <div class="space-y-3 pb-24">
                @forelse($transactions as $transaction)
                <div class="flex items-center justify-between p-4 bg-white rounded-xl shadow-sm border border-gray-100">
                    @php
                        $currentCrypto = strtolower($asset['symbol']);
                        if ($asset['network']) {
                            $currentCrypto = strtolower($asset['symbol']) . '_' . strtolower($asset['network']);
                        }
                        
                        // Check if this is a funding transaction
                        if ($transaction->type === 'funding') {
                            $isIncoming = false;
                            $amount = $transaction->amount_out;
                        }
                        // Check for swap transactions
                        elseif ($transaction->type === 'swap') {
                            $isIncoming = $transaction->to_crypto === $currentCrypto;
                            $amount = $isIncoming ? $transaction->amount_out : $transaction->amount_in;
                        }
                        // For other transaction types
                        else {
                            $isIncoming = in_array($transaction->type, ['deposit', 'refund']);
                            $amount = $isIncoming ? $transaction->amount_in : $transaction->amount_out;
                        }
                        
                        // Set icon and color based on status
                        if ($transaction->status === 'pending') {
                            $iconBg = 'bg-yellow-50';
                            $iconColor = 'text-yellow-500';
                            $iconDirection = 'fa-spinner fa-spin';
                            $amountPrefix = '';
                            $amountClass = 'text-yellow-500';
                        } else {
                            $iconBg = $isIncoming ? 'bg-green-50' : 'bg-red-50';
                            $iconColor = $isIncoming ? 'text-green-500' : 'text-red-500';
                            $iconDirection = $isIncoming ? 'fa-arrow-down' : 'fa-arrow-up';
                            $amountPrefix = $isIncoming ? '+' : '-';
                            $amountClass = $isIncoming ? 'text-green-500' : 'text-red-500';
                        }

                        // Format display names for swaps
                        $fromCryptoDisplay = strtoupper(explode('_', $transaction->from_crypto)[0]);
                        $toCryptoDisplay = strtoupper(explode('_', $transaction->to_crypto)[0]);
                        if (strpos($transaction->from_crypto, '_') !== false) {
                            $networkFrom = explode('_', $transaction->from_crypto)[1];
                            $fromCryptoDisplay .= ' ' . strtoupper($networkFrom);
                        }
                        if (strpos($transaction->to_crypto, '_') !== false) {
                            $networkTo = explode('_', $transaction->to_crypto)[1];
                            $toCryptoDisplay .= ' ' . strtoupper($networkTo);
                        }
                    @endphp
                    
                    <div class="flex items-center">
                        <div class="w-10 h-10 {{ $iconBg }} rounded-full flex items-center justify-center mr-3">
                            <i class="fas {{ $iconDirection }} {{ $iconColor }}"></i>
                        </div>
                        <div>
                            <h3 class="font-medium text-gray-900">
                                @if($transaction->type === 'funding')
                                    Funded Card
                                @elseif($transaction->type === 'swap')
                                    @if($isIncoming)
                                        Swapped from {{ $fromCryptoDisplay }}
                                    @else
                                        Swapped to {{ $toCryptoDisplay }}
                                    @endif
                                @else
                                    {{ ucfirst($transaction->type) }}
                                @endif
                            </h3>
                            <p class="text-sm text-gray-500">
                                {{ $transaction->created_at->format('M d, Y') }}
                            </p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="{{ $amountClass }} font-medium">
                            {{ $amountPrefix }}{{ number_format($amount, 6) }} {{ $asset['symbol'] }}
                        </p>
                        @if(isset($transaction->metadata['usd_value']))
                            <p class="text-sm text-gray-500">
                                ${{ number_format($transaction->metadata['usd_value'], 2) }}
                            </p>
                        @endif
                    </div>
                </div>
                @empty
                <div class="text-center py-10 bg-white rounded-xl shadow-sm border border-gray-100">
                    <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-exchange-alt text-gray-400 text-2xl"></i>
                    </div>
                    <p class="text-gray-600 font-medium mb-6">No transactions yet</p>
                    <a href="{{ route('buy.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native']) }}" 
                            class="bg-blue-500 hover:bg-blue-600 text-white font-medium py-3 px-6 rounded-xl transition-colors inline-flex items-center">
                        <i class="fas fa-credit-card mr-2"></i>
                        Buy {{ $asset['symbol'] }}
                    </a>
                </div>
                @endforelse
            </div>
        </div>

        <!-- Send Modal -->
        <div id="assetSendModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
            <div class="bg-white w-full md:w-96 md:rounded-xl mt-auto sm:mt-24 relative animate-modal-show">
                <div class="flex items-center justify-between p-4 border-b border-gray-100">
                    <h2 class="text-lg font-medium text-gray-900">Send {{ $asset['symbol'] }}</h2>
                    <button onclick="closeAssetSendModal()" class="w-8 h-8 rounded-full bg-gray-100 flex items-center justify-center text-gray-500 hover:bg-gray-200">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="p-4 space-y-3">
                    <a href="{{ route('send.payid.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native']) }}" 
                        class="block bg-white hover:bg-gray-50 rounded-xl p-4 border border-gray-100">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-blue-50 rounded-full flex items-center justify-center mr-3">
                                <i class="fas fa-shield-alt text-blue-500"></i>
                            </div>
                            <div>
                                <h3 class="font-medium text-blue-500">Send via Qfs Ledger PayId</h3>
                                <p class="text-sm text-gray-500 mt-1">Send coins from Qfs Ledger to Qfs Ledger fast and free. No network fee</p>
                            </div>
                        </div>
                    </a>

                    <a href="{{ route('send.external.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native']) }}" 
                        class="block bg-white hover:bg-gray-50 rounded-xl p-4 border border-gray-100">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-blue-50 rounded-full flex items-center justify-center mr-3">
                                <i class="fas fa-coins text-blue-500"></i>
                            </div>
                            <div>
                                <h3 class="font-medium text-gray-900">Send via {{ $asset['symbol'] }}</h3>
                                <p class="text-sm text-gray-500 mt-1">Send coins from your Qfs Ledger crypto wallet. Network fees included</p>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Receive Modal -->
        <div id="assetReceiveModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
            <div class="bg-white w-full md:w-96 md:rounded-xl mt-auto sm:mt-24 relative animate-modal-show">
                <div class="flex items-center justify-between p-4 border-b border-gray-100">
                    <h2 class="text-lg font-medium text-gray-900">Receive {{ $asset['symbol'] }}</h2>
                    <button onclick="closeAssetReceiveModal()" class="w-8 h-8 rounded-full bg-gray-100 flex items-center justify-center text-gray-500 hover:bg-gray-200">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="p-4 space-y-3">
                    <a href="{{ route('receive.payid.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native']) }}" 
                        class="block bg-white hover:bg-gray-50 rounded-xl p-4 border border-gray-100">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-blue-50 rounded-full flex items-center justify-center mr-3">
                                <i class="fas fa-shield-alt text-blue-500"></i>
                            </div>
                            <div>
                                <h3 class="font-medium text-blue-500">Receive via Qfs Ledger PayId</h3>
                                <p class="text-sm text-gray-500 mt-1">Receive coins from Qfs Ledger to Qfs Ledger fast and free. No network fee</p>
                            </div>
                        </div>
                    </a>

                    <a href="{{ route('receive.external.details', ['symbol' => strtolower($asset['symbol']), 'network' => $asset['network'] ?? 'native']) }}" 
                        class="block bg-white hover:bg-gray-50 rounded-xl p-4 border border-gray-100">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-blue-50 rounded-full flex items-center justify-center mr-3">
                                <i class="fas fa-coins text-blue-500"></i>
                            </div>
                            <div>
                                <h3 class="font-medium text-gray-900">Receive via {{ $asset['symbol'] }}</h3>
                                <p class="text-sm text-gray-500 mt-1">Receive coins from your Qfs Ledger crypto wallet. Network fees included</p>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </main>

    <style>
    .animate-modal-show {
        animation: modalShow 0.3s ease-out;
    }
    
    @keyframes modalShow {
        from {
            opacity: 0;
            transform: translateY(50px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    </style>

    @push('scripts')
    <script>
        function openAssetSendModal() {
            document.getElementById('assetSendModal').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closeAssetSendModal() {
            const modal = document.getElementById('assetSendModal');
            modal.classList.add('opacity-0');
            setTimeout(() => {
                modal.classList.add('hidden');
                modal.classList.remove('opacity-0');
                document.body.style.overflow = '';
            }, 200);
        }

        function openAssetReceiveModal() {
            document.getElementById('assetReceiveModal').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closeAssetReceiveModal() {
            const modal = document.getElementById('assetReceiveModal');
            modal.classList.add('opacity-0');
            setTimeout(() => {
                modal.classList.add('hidden');
                modal.classList.remove('opacity-0');
                document.body.style.overflow = '';
            }, 200);
        }

        // Close modals when clicking outside
        window.addEventListener('click', function(event) {
            const sendModal = document.getElementById('assetSendModal');
            const receiveModal = document.getElementById('assetReceiveModal');

            if (event.target === sendModal) {
                closeAssetSendModal();
            }

            if (event.target === receiveModal) {
                closeAssetReceiveModal();
            }
        });
    </script>
    @endpush
</x-user-layout>