@props(['errors'])

@if ($errors->any())
    <div {{ $attributes->merge(['class' => 'mb-4']) }}>
        <div class="font-medium text-red-600 dark:text-red-400">
            {{ __('Whoops! Something went wrong.') }}
        </div>

        <ul class="mt-3 list-disc list-inside text-sm text-red-600 dark:text-red-400">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif