<x-admin-layout>
    <div class="container px-6 mx-auto">
        <div class="flex justify-between items-center my-6">
            <h2 class="text-2xl font-semibold text-gray-700">
                Wallets for {{ $user->name }}
                <span class="text-sm text-gray-500 ml-2">(ID: {{ $user->uuid }})</span>
            </h2>
            
            <div class="text-right">
                <p class="text-sm text-gray-600">Total Balance</p>
                <p class="text-2xl font-bold text-purple-600">${{ number_format($user->getTotalBalanceUSD(), 2) }}</p>
            </div>
        </div>

       <x-session-status class="mb-4" :status="session('status')" :errors="$errors" />

        <!-- Crypto Assets Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($supportedCryptos as $symbol => $crypto)
                <div class="bg-white rounded-lg shadow-md overflow-hidden">
                    <div class="p-4 border-b border-gray-200">
                        <div class="flex items-center justify-between mb-2">
                           <div class="flex items-center">
    <div class="w-8 h-8 rounded-full flex items-center justify-center mr-3">
        <img 
            src="{{ asset('images/' . ($crypto['name'] === 'USDT' && isset($crypto['network']) ? strtolower('usdt_' . $crypto['network']) : strtolower($crypto['name'])) . '-icon.png') }}" 
            alt="{{ $crypto['name'] }} icon" 
            class="w-full h-full object-contain"
        >
    </div>
    <div>
        <h3 class="font-semibold text-gray-800">{{ $crypto['name'] }}</h3>
        <p class="text-xs text-gray-500">
            {{ strtoupper($symbol) }}
            @if(isset($crypto['network']))
                <span class="ml-1 px-1.5 py-0.5 bg-gray-100 rounded-full">
                    {{ $crypto['network'] }}
                </span>
            @endif
        </p>
    </div>
</div>
                            <!-- Status Toggle -->
<form action="{{ route('admin.users.crypto.update', $user) }}" method="POST" class="inline">
    @csrf
    @method('PUT')
    <input type="hidden" name="status_update" value="1">
    <input type="hidden" name="crypto" value="{{ $symbol }}">
    <label class="relative inline-flex items-center cursor-pointer">
        <input type="checkbox" 
               class="sr-only peer"
               name="{{ $symbol }}_status"
               value="1"
               {{ $cryptoAssets->{$symbol.'_status'} ? 'checked' : '' }}
               onchange="this.form.submit()">
        <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-purple-600"></div>
    </label>
</form>
                        </div>
                    </div>

                    <div class="p-4 space-y-4">
                        <!-- Balance Information -->
                        <div>
                            <p class="text-sm text-gray-600">Balance</p>
                            <p class="text-2xl font-bold text-gray-800">
                                {{ number_format($cryptoAssets->{$symbol.'_balance'}, 8) }}
                            </p>
                        </div>

                        <!-- Wallet Address -->
                        <div>
                            <p class="text-sm text-gray-600 mb-1">Wallet Address</p>
                            <div class="flex items-center space-x-2">
                                <input type="text" 
                                       value="{{ $cryptoAssets->{$symbol.'_address'} }}" 
                                       class="text-xs bg-gray-50 border border-gray-300 rounded px-2 py-1 w-full"
                                       readonly>
                                <button type="button" 
                                        onclick="copyToClipboard('{{ $cryptoAssets->{$symbol.'_address'} }}')"
                                        class="p-1 text-gray-500 hover:text-gray-700">
                                    <i class="ri-file-copy-line"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Balance Adjustment Form -->
                        <form id="update-crypto-{{ $symbol }}" 
                              action="{{ route('admin.users.crypto.update', $user) }}" 
                              method="POST" 
                              class="space-y-3">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="crypto" value="{{ $symbol }}">
                            
                            <div class="flex space-x-2">
                                <div class="flex-1">
                                    <label class="sr-only">Amount</label>
                                    <input type="number" 
                                           name="amount" 
                                           step="0.00000001"
                                           class="block w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500"
                                           placeholder="Enter amount...">
                                </div>
                                <button type="submit" 
                                        name="action" 
                                        value="add"
                                        class="px-4 py-2 text-sm font-medium text-white bg-green-600 rounded-lg hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500">
                                    Add
                                </button>
                                <button type="submit" 
                                        name="action" 
                                        value="subtract"
                                        class="px-4 py-2 text-sm font-medium text-white bg-red-600 rounded-lg hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-500">
                                    Subtract
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(() => {
                // You could add a toast notification here
                alert('Address copied to clipboard!');
            });
        }
    </script>
</x-admin-layout>