<x-admin-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Wallet Settings') }}
            </h2>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    
                    <x-session-status class="mb-4" :status="session('status')" :errors="$errors" />

                    <form method="POST" action="{{ route('admin.settings.wallets.update') }}">
                        @csrf
                        @method('PUT')

                        <div class="mb-6">
                            <div class="flex justify-between items-center mb-4">
                                <h3 class="text-lg font-medium">Cryptocurrency Wallet Addresses</h3>
                            </div>

                            <div class="grid grid-cols-1 gap-6">
                                <!-- BTC -->
                                <div>
                                    <label for="btc_address" class="block text-sm font-medium text-gray-700">Bitcoin (BTC) Address</label>
                                    <input type="text" name="btc_address" id="btc_address"
                                           value="{{ old('btc_address', $settings['btc_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- ETH -->
                                <div>
                                    <label for="eth_address" class="block text-sm font-medium text-gray-700">Ethereum (ETH) Address</label>
                                    <input type="text" name="eth_address" id="eth_address"
                                           value="{{ old('eth_address', $settings['eth_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- USDT TRC20 -->
                                <div>
                                    <label for="usdt_trc20_address" class="block text-sm font-medium text-gray-700">USDT (TRC20) Address</label>
                                    <input type="text" name="usdt_trc20_address" id="usdt_trc20_address"
                                           value="{{ old('usdt_trc20_address', $settings['usdt_trc20_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- USDT ERC20 -->
                                <div>
                                    <label for="usdt_erc20_address" class="block text-sm font-medium text-gray-700">USDT (ERC20) Address</label>
                                    <input type="text" name="usdt_erc20_address" id="usdt_erc20_address"
                                           value="{{ old('usdt_erc20_address', $settings['usdt_erc20_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- USDT BEP20 -->
                                <div>
                                    <label for="usdt_bep20_address" class="block text-sm font-medium text-gray-700">USDT (BEP20) Address</label>
                                    <input type="text" name="usdt_bep20_address" id="usdt_bep20_address"
                                           value="{{ old('usdt_bep20_address', $settings['usdt_bep20_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- TRX -->
                                <div>
                                    <label for="trx_address" class="block text-sm font-medium text-gray-700">TRON (TRX) Address</label>
                                    <input type="text" name="trx_address" id="trx_address"
                                           value="{{ old('trx_address', $settings['trx_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- BCH -->
                                <div>
                                    <label for="bch_address" class="block text-sm font-medium text-gray-700">Bitcoin Cash (BCH) Address</label>
                                    <input type="text" name="bch_address" id="bch_address"
                                           value="{{ old('bch_address', $settings['bch_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- LTC -->
                                <div>
                                    <label for="ltc_address" class="block text-sm font-medium text-gray-700">Litecoin (LTC) Address</label>
                                    <input type="text" name="ltc_address" id="ltc_address"
                                           value="{{ old('ltc_address', $settings['ltc_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- XLM -->
                                <div>
                                    <label for="xlm_address" class="block text-sm font-medium text-gray-700">Stellar (XLM) Address</label>
                                    <input type="text" name="xlm_address" id="xlm_address"
                                           value="{{ old('xlm_address', $settings['xlm_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- DASH -->
                                <div>
                                    <label for="dash_address" class="block text-sm font-medium text-gray-700">Dash (DASH) Address</label>
                                    <input type="text" name="dash_address" id="dash_address"
                                           value="{{ old('dash_address', $settings['dash_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- SOL -->
                                <div>
                                    <label for="sol_address" class="block text-sm font-medium text-gray-700">Solana (SOL) Address</label>
                                    <input type="text" name="sol_address" id="sol_address"
                                           value="{{ old('sol_address', $settings['sol_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- BNB -->
                                <div>
                                    <label for="bnb_address" class="block text-sm font-medium text-gray-700">Binance Coin (BNB) Address</label>
                                    <input type="text" name="bnb_address" id="bnb_address"
                                           value="{{ old('bnb_address', $settings['bnb_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- DOT -->
                                <div>
                                    <label for="dot_address" class="block text-sm font-medium text-gray-700">Polkadot (DOT) Address</label>
                                    <input type="text" name="dot_address" id="dot_address"
                                           value="{{ old('dot_address', $settings['dot_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>
                                
                                <!-- DOGE -->
                                <div>
                                    <label for="doge_address" class="block text-sm font-medium text-gray-700">Dogecoin (DOGE) Address</label>
                                    <input type="text" name="doge_address" id="doge_address"
                                           value="{{ old('doge_address', $settings['doge_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- XDC -->
                                <div>
                                    <label for="xdc_address" class="block text-sm font-medium text-gray-700">XDC Network (XDC) Address</label>
                                    <input type="text" name="xdc_address" id="xdc_address"
                                           value="{{ old('xdc_address', $settings['xdc_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>

                                <!-- XRP -->
                                <div>
                                    <label for="xrp_address" class="block text-sm font-medium text-gray-700">Ripple (XRP) Address</label>
                                    <input type="text" name="xrp_address" id="xrp_address"
                                           value="{{ old('xrp_address', $settings['xrp_address'] ?? '') }}"
                                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700">
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" 
                                    class="px-4 py-2 bg-purple-600 text-white rounded hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2">
                                Save Wallet Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>