# has-package-exports <sup>[![Version Badge][npm-version-svg]][package-url]</sup>

[![dependency status][deps-svg]][deps-url]
[![dev dependency status][dev-deps-svg]][dev-deps-url]
[![License][license-image]][license-url]
[![Downloads][downloads-image]][downloads-url]

[![npm badge][npm-badge-png]][package-url]

Does the current node version have support for the "exports" field in package.json?

At the time of this writing, node v12.17+ and v13+ has support for the ["exports" field in package.json](https://nodejs.org/api/packages.html#packages_exports).

This library exports `true` if the current node version supports it, `false` if it does not, and `null` if it's in a browser.

Require or import `has-package-exports/conditional` to determine if the current environment supports conditional exports (as of this writing, node v12.17+ and v13.7+).

Require or import `has-package-exports/pattern` to determine if the current environment supports exports patterns (as of this writing, node v12.20+ and v14.13+).

## Tests
Simply clone the repo, `npm install`, and run `npm test`

[package-url]: https://npmjs.org/package/has-package-exports
[npm-version-svg]: https://versionbadg.es/inspect-js/has-package-exports.svg
[deps-svg]: https://david-dm.org/inspect-js/has-package-exports.svg
[deps-url]: https://david-dm.org/inspect-js/has-package-exports
[dev-deps-svg]: https://david-dm.org/inspect-js/has-package-exports/dev-status.svg
[dev-deps-url]: https://david-dm.org/inspect-js/has-package-exports#info=devDependencies
[npm-badge-png]: https://nodei.co/npm/has-package-exports.png?downloads=true&stars=true
[license-image]: https://img.shields.io/npm/l/has-package-exports.svg
[license-url]: LICENSE
[downloads-image]: https://img.shields.io/npm/dm/has-package-exports.svg
[downloads-url]: https://npm-stat.com/charts.html?package=has-package-exports
